#coding: utf-8
from django.db import models
from feincms.models import Base
from django.utils.translation import ugettext_lazy as _
from feincms.models import create_base_model
from mptt.models import MPTTModel
from datetime import datetime
#from contents.models import Section

from django.db.models import get_model


#Client
class Menu(models.Model):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='sitemenus_menus_website', default=1)
    #ref = models.CharField(_(u'referência'), max_length=10, blank=True, null=True)
    title = models.CharField(_(u'título'), max_length=200, blank=True, null=True)

    def __unicode__(self):
        return self.title

    class Meta:
        pass



TEMPLATE_CHOICES=(
    (1, u'Home'),
    (2, u'Listagem de Notícias'),
    (3, u'Detalhes de Notícia'),
    (4, u'Detalhes de Horário'),
    (5, u'Listagem de Sacerdotes'),
    (6, u'Formulário de Contactos'),
    (7, u'Listagem de Agenda'),
    (8, u'Listagem de Fotogaleria'),
    (9, u'Listagem de Videos'),
    (10, u'Localização'),
    (11, u'Listagem de Downloads'),
)


class MenuTree(create_base_model(MPTTModel)):
#class MenuTree(MPTTModel):
    website = models.ForeignKey(get_model('website','WebSite'), verbose_name=_(u'Website'), related_name='sitemenus_menutrees_website', default=1)
    menu = models.ForeignKey('Menu', verbose_name=_('menu'))
    #ref = models.CharField(_(u'referência'), max_length=10, blank=True, null=True)
    title = models.CharField(_(u'título'), max_length=200)#, blank=True, null=True
    link = models.CharField(_(u'url'), max_length=255, blank=True, null=True)
    #picture = models.CharField(_(u'imagem'), max_length=80,null=True,blank=True)
    #section = models.ForeignKey(Section, verbose_name=_('secção'), blank=True, null=True)
    template = models.PositiveIntegerField(_(u'Template'), max_length=2, choices=TEMPLATE_CHOICES, blank=True, null=True)

    #home_noticia = models.ForeignKey('conteudos.Noticia', verbose_name=_(u'Notícia Bem-Vindo'), blank=True, null=True,
    #     related_name='websites_websites_conteudo_noticia', on_delete=models.SET_NULL)
    #home_noticias = models.ForeignKey('conteudos.Seccao', verbose_name=_(u'Secção Notícias'), blank=True, null=True,
    #     related_name='websites_websites_seccao_avisos', on_delete=models.SET_NULL)
    #fotogaleria_seccao = models.ForeignKey('conteudos.Seccao', verbose_name=_(u'Secção Fotogaleria'), blank=True, null=True,
    #     related_name='websites_websites_fotogaleria_seccao', on_delete=models.SET_NULL)

    noticias_noticias = models.ForeignKey('conteudos.Seccao', verbose_name=_(u'Secção'), blank=True, null=True,
         related_name='websites_websites_noticias_noticias', on_delete=models.SET_NULL)

    noticia_noticia = models.ForeignKey('conteudos.Noticia', verbose_name=_(u'Notícia'), blank=True, null=True,
         related_name='websites_websites_conteudo_conteudo', on_delete=models.SET_NULL)

    #horario_horario = models.ForeignKey('horario.Horario', verbose_name=_(u'Horário'), blank=True, null=True,
    #     related_name='websites_websites_horario_horario', on_delete=models.SET_NULL)

    #sacerdotes_paroquia = models.ForeignKey('diocese.Paroquia', verbose_name=_(u'Paroquia'), blank=True, null=True,
    #     related_name='websites_websites_sacerdotes_paroquia', on_delete=models.SET_NULL)

    #contactos_noticia = models.ForeignKey('conteudos.Noticia', verbose_name=_(u'Notícia Contactos'), blank=True, null=True,
    #     related_name='websites_websites_contactos_noticia', on_delete=models.SET_NULL)


    """
    seccao = models.ForeignKey(Section, verbose_name=_('secção'), blank=True, null=True)
    noticia = models.ForeignKey(Noticia, verbose_name=_('noticía'), blank=True, null=True)
    paroquia = models.ForeignKey(Paroquia, verbose_name=_('paroquia'), blank=True, null=True)
    """

    active = models.BooleanField(_(u'activo'), default=True)
    created = models.DateTimeField(default=datetime.now)
    parent = models.ForeignKey('self', verbose_name=_(u'Pai'), blank=True, null=True, related_name='children')

    def __unicode__(self):
        if self.title != '':
            return self.title
        else:
            return '(Nada)'
        """
        if self.section!= None:
            return self.section.title
        else:
            if self.title != '':
                return self.title
            else:
                return '(Nada)'
        """

    class Meta:
        verbose_name = _(u'Menu Árvore')
        verbose_name_plural = _(u'Menu Árvores')

    def content_type_menu_links(self):
        content_type_menu_links = [
                None,
                '/',
                '/noticias/(?P<pk>\d+)/',
                '/noticia/(?P<pk>\d+)/',
                '/horario/',
                '/sacerdotes/',
                '/contactos/',
                '/agenda/',
                '/fotogaleria/(?P<sec>\d+)/',
                '/videos/(?P<sec>\d+)/',
                '/localizacao/',
                '/downloads/(?P<pk>\d+)/',
            ]
        linkpk = ''
        linksec = ''
        try:
            if self.template == 2 or self.template == 11:
                linkpk=self.noticias_noticias.pk
            elif self.template ==3:
                linkpk=self.noticia_noticia.pk
            elif self.template ==8 or self.template ==9:
                linksec=self.noticias_noticias.pk
        except Exception, e:
            linkpk=''
            #pass

        return content_type_menu_links[self.template].replace('(?P<pk>\d+)', str(linkpk)).replace('(?P<sec>\d+)', str(linksec))

# ---------------------
