#coding: utf-8
from django.contrib import admin
from sms_email import models as MODsms_email
from sms_email import inlines as INLsms_email
from django.utils.translation import ugettext_lazy as _

from django import forms
from redactor.widgets import JQueryEditor as RedactorEditor



class BaseAdmin(admin.ModelAdmin):
    change_list_template = 'actionslistview.html'
    row_actions = []


# Users
class UserAdmin(BaseAdmin):
    save_on_top = True
    list_display = ('name', 'email', 'number', 'get_groups', 'id')
    search_fields = ('id', 'email', 'name', 'number' )
    list_filter = ('groups', 'tipo_entidade', 'arciprestado' )

    inlines = [INLsms_email.UserGroupInline]

    def get_groups(self, e):
        grps = []
        z = e.groups.all().values('title')

        for g in z:
            grps.append(g['title'])

        if len(grps) == 0:
            return None

        return ', '.join(grps)

    get_groups.short_description = _(u'Grupos')

admin.site.register(MODsms_email.User, UserAdmin)
# ---------------------


# Groups
class GroupAdmin(BaseAdmin):
    save_on_top = True
    list_display = ('title', 'id')
    search_fields = ('id', 'title')
    inlines = [INLsms_email.UserGroupInline]

admin.site.register(MODsms_email.Group, GroupAdmin)




class SmsEmailForm(forms.ModelForm):
    #noticia = forms.CharField(widget=tinymce_widgets.AdminTinyMCE)
    noticia = forms.CharField(widget=RedactorEditor(), required=False)
    class Meta:
        model = MODsms_email.SmsEmail
        widgets = {
            'fs': forms.widgets.HiddenInput,
            #'capa': ElfinderImageWidget(attrs={'a':'a'}),
        }


# Newsletter
#from newsletter.forms import NewsletterForm
class SmsEmailAdmin(BaseAdmin):
    form = SmsEmailForm
    save_on_top = True
    list_display = ('title', 'active', 'id')
    search_fields = ('id', 'title', )
    """
    fieldsets = (
                 (_(u'Newsletter'), {
                                     'fields': (
                                                'ref', 'website', 'active',
                                                'title',
                                                ('start_date', 'last_sended'),
                                                'ntype',
                                                'subject', 'body'
                                                )
                                     }),
                 (_(u'Especiais'), {
                                   'fields': (
                                              'send_pdf_destaque',
                                              'send_news',
                                              'send_news_number'
                                              ),
                                   'classes': ['collapse', ],
                                   })
                 )
    """
    inlines = [
               INLsms_email.SmsEmailGroupInline,
               INLsms_email.SmsEmailUserInline,
               ]

admin.site.register(MODsms_email.SmsEmail, SmsEmailAdmin)


class SmsQueueAdmin(admin.ModelAdmin):
    #form = NewsletterForm
    save_on_top = True
    inlines = [INLsms_email.SmsQueueNumberInline]


admin.site.register(MODsms_email.SmsQueue, SmsQueueAdmin)
