# -*- coding: utf-8 *-*
from django.conf import settings
from .models import *
import os
import sys
from datetime import datetime, timedelta

from django.conf import settings as django_settings
from peakitcms.funcionalidades.Mailer import Mailer
from sms_email.models import SmsEmail, SmsQueue, SmsQueueNumbers
from newsletter.models import Quee
from .sms import SendSms



class PIDControler(object):
	pid = str(os.getpid())

	def __init__(self, f):
		self.pidfile = '%(PID_PATH)s/%(MY_APP)s_sms_email_%(pidfile)s.pid' % {
									'PID_PATH': getattr(settings, 'PATH', '/') + 'tmp/',
									'pidfile': f,
									'MY_APP': getattr(settings, 'MY_APP', 'peakit')
								}

	def is_runing(self):
		if os.path.isfile(self.pidfile): #O pid existe?
			agora = datetime.now()
			then = datetime.fromtimestamp(os.path.getmtime(self.pidfile))
			if (agora - then) > timedelta (minutes = getattr(settings, 'PID_LIFETIME', 1)): #O pid existe a x tempo?
				with file(self.pidfile, 'a'):
					os.utime(self.pidfile, None)
				return False
			return True
		else:
			file(self.pidfile, 'w').write(self.pid)
		return False

	def clear(self):
		try:
			os.unlink(self.pidfile)
		except:
			pass

def add_queue():
	pid = PIDControler('add_queue')
	if not pid.is_runing():
		smsemails_enviar = SmsEmail.objects.filter(active=True, send_date__isnull=True)[:10]
		for sms_email in smsemails_enviar:
			if sms_email.ntype in (1,3):
				for email in sms_email.get_emails():
					mailer = Mailer(getattr(django_settings, 'NEWSLETTER_FROM_EMAIL'), email, sms_email.subject, sms_email.noticia)
					mailer.queue = Quee
					mailer.send()

			if sms_email.ntype in (2,3):
				numbers = sms_email.get_numbers()
				if len(numbers) > 0:
					sms_q = SmsQueue.objects.create(body=sms_email.sms_body)
					sms_q.save()
					for number in numbers:
						SmsQueueNumbers.objects.create(to_number=number, sms=sms_q).save()
			sms_email.send_date = datetime.now()
			sms_email.save()
    	pid.clear()


def dispatch_queue():
	pid = PIDControler('dispatch_queue')
	if not pid.is_runing():
		for sms_q in SmsQueue.objects.order_by('-trys')[:10]:
			numbers = map(lambda x: x.to_number, sms_q.smsqueue_number.all())
			ok=True
			error_message = ''
			if len(numbers)>0:
				try:
					result = SendSms().send(sms_q.body, numbers)
					ok=result['ok']
					error_message = result['message']
				except Exception,e:
					ok=False
					error_message = str(e)
        
		        handle1=open(settings.PATH+'static/smslogs.txt','a+')
		        handle1.write(str(datetime.today())+' - '+error_message+"\r\n")
		        handle1.close();
		        
			if ok:
				sms_q.delete()
			else:
				sms_q.last_error_message = error_message
				sms_q.trys += 1
				sms_q.save()
		pid.clear()
