#coding: utf-8
from django.db import models
from django.utils.translation import ugettext_lazy as _
from django.db.models import Q
from django.template import Context, Template
from peakitcms.funcionalidades.Mailer import Mailer
from django.conf import settings as django_settings

from feincms.models import Base
from inline_ordering.models import Orderable
from diocese.models import Arciprestado
#from newsletter import options as OPTnewsletter
#from conteudos import models as Mconteudos
from peakitcms.conteudos.templates.models import getBaseTemplate
#from website.models import WebSite
import re
from datetime import datetime, timedelta



from elfinder.models import FileCollection


def foldr(a, b, l):
    if l == []:
        return b
    else:
        return a(l[0], foldr(a, b, l[1:]))


class User(Base):
    TIPOS_ENTIDADES=(
        ('1','Bispos'),
        ('2','Cónego'),
        ('3','Diácono Permanente'),
        ('4','Diácono'),
        ('5','Dom'),
        ('6','Mons. Cónego'),
        ('7','Monsehor'),
        ('8','Padre'),
    )
    name = models.CharField(
        _(u'name'), max_length=255,
    )
    # codigo de bosta nos models da diocese
    email = models.CharField(_(u'email'), max_length=255, null=True, blank=True)
    # codigo de bosta nos models da diocese
    number = models.CharField(
        _(u'number'), max_length=255, null=True, blank=True
    )

    groups = models.ManyToManyField('Group', through='UserGroup',
        related_name='sms_email_user_groups', null=True, blank=True)

    arciprestado = models.ForeignKey(Arciprestado,
        verbose_name=_(u'arciprestado'), null=True, blank=True
    )

    tipo_entidade = models.CharField(_(u'tipo_entidade'), max_length=2,
        null=True, blank=True,
        choices=TIPOS_ENTIDADES,
    )

    import_model = models.CharField(
        _(u'import_model'), max_length=255,
        null=True, blank=True
    )
    import_pk = models.IntegerField(_(u'import_pk'), null=True, blank=True)

    def __unicode__(self):
        return self.name

    class Meta:
        verbose_name = _(u'utilizador')
        verbose_name_plural = _(u'utilizadores')
        unique_together = ( 'import_model', 'import_pk')


    def get_emails(self):
        if self.email is None:
            return []
        clean_email = (
            (' ou ','/'),
            (';','/'),
            ('   ','/'),
            (' ',''),
        )
        emails = foldr(lambda x,i: i.replace(x[0],x[1]), self.email, list(clean_email) ).split('/')
        return set(filter(lambda x: '@' in x, emails) )

    def get_numbers(self):
        if self.number is None:
            return []
        clean_number = (

            ('+351',''),
            ('00351',''),
            ('.',''),
            ('ou','/'),
            (' ',''),
            ('+','00'),
        )
        number = foldr(lambda x,i: i.replace(x[0],x[1]), self.number, list(clean_number) ).split('/')
        return set(filter(lambda x: len(x)>=9 and re.match(r"^\d+$",x) is not None , number ))







class Group(Base):
    ref = models.CharField(_(u'referência'), max_length=255, null=True,
        blank=True, unique=True)
    active = models.BooleanField(_(u'activo'), default=True)
    title = models.CharField(_(u'título'), max_length=255)

    users = models.ManyToManyField('User', through='UserGroup',
        related_name='group_users', null=True, blank=True)
    def __unicode__(self):
        return self.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')

    def get_emails(self):
        emails = []
        for user in self.users.all():
            emails += user.get_emails()
        return set(emails)

    def get_numbers(self):
        numbers = []
        for user in self.users.all():
            numbers += user.get_numbers()
        return set(numbers)


class UserGroup(Base):
    user = models.ForeignKey(User, verbose_name=_(u'utilizador'),
        related_name='usergroup_user', db_index=True)
    group = models.ForeignKey(Group, verbose_name=_(u'grupo'),
        related_name='usergroup_group', db_index=True)

    def __unicode__(self):
        return self.group.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')
        unique_together = (("user", "group"),)




class SmsEmail(Base):
    SEND_TYPE = (
        (1, 'Email'),
        (2, 'Sms'),
        (3, 'Sms e Email'),

    )
    ref = models.CharField(_(u'referência'), max_length=255, null=True,
        blank=True)
    title = models.CharField(_(u'título'), max_length=255)
    active = models.BooleanField(_(u'activa'), default=False)
    subject = models.CharField(_(u'assunto'), max_length=255)
    noticia = models.TextField(_(u'noticia'), null=True, blank=True)
    sms_body = models.TextField(_(u'sms'), null=True, blank=True)
    ntype = models.IntegerField(_('tipo'), choices=SEND_TYPE,
        default=1)
    send_date = models.DateTimeField(_(u'data_envio'), blank=True, null=True,
        db_index=True)

    fs = models.ForeignKey(FileCollection, related_name='sms_emailss_sms_emailss_file_collection', editable=True, null=True, blank=True)
    
    groups = models.ManyToManyField('Group', through='SmsEmailGroup',
        related_name='smsemail_groups', null=True, blank=True)
    users = models.ManyToManyField('User', through='SmsEmailUser',
        related_name='smsemail_users', null=True, blank=True)

    def __unicode__(self):
        return self.title

    def get_emails(self):
        emails = []
        for user in self.users.all():
            emails += user.get_emails()
        for group in self.groups.all():
            emails += group.get_emails()
        return set(emails)

    def get_numbers(self):
        numbers = []
        for user in self.users.all():
            numbers += user.get_numbers()
        for group in self.groups.all():
            numbers += group.get_numbers()
        return set(numbers)


class SmsEmailGroup(Base):
    smsemail = models.ForeignKey(SmsEmail, verbose_name=_(u'newsletter'),
        related_name='sms_emails_smsemailgroups_smsemail', db_index=True)
    group = models.ForeignKey(Group, verbose_name=_(u'grupo'),
        related_name='sms_emails_smsemailgroups_group', db_index=True)

    def __unicode__(self):
        return self.group.title

    class Meta:
        verbose_name = _(u'grupo')
        verbose_name_plural = _(u'grupos')
        unique_together = (("smsemail", "group"),)


class SmsEmailUser(Base):
    smsemail = models.ForeignKey(SmsEmail, verbose_name=_(u'newsletter'),
        related_name='sms_emails_smsemailusers_smsemail', db_index=True)
    user = models.ForeignKey(User, verbose_name=_(u'user'),
        related_name='sms_emails_smsemailusers_user', db_index=True)

    class Meta:
        verbose_name = _(u'user')
        verbose_name_plural = _(u'users')
        unique_together = (("smsemail", "user"),)

    def __unicode__(self):
        return self.user.name


class SmsQueue(Base):
    body = models.TextField(_(u'content'), )
    data = models.DateTimeField(_(u'data'), default=datetime.now())
    trys = models.IntegerField(_(u'tentativas'), default=0)
    last_error_message = models.TextField(_(u'last error message'), null=True, blank=True)
    def __unicode__(self):
        return self.body

    class Meta:
        verbose_name = _(u'sms queue')
        verbose_name_plural = _(u'sms queues')


class SmsQueueNumbers(Base):
    sms = models.ForeignKey(SmsQueue, verbose_name=_(u'sms'),
            related_name='smsqueue_number', db_index=True
    )
    to_number = models.CharField(_(u'para'), max_length=255)
