#coding: utf-8


from django.db.models.signals import post_save, post_delete
from .models import User, Group
from django.template.defaultfilters import slugify
from diocese.models import Presbitero, DiaconoPermanente, Bispo, Diacono


def insert_user_in_group(user):
    key_group = slugify(user.get_tipo_entidade_display())
    group, c = Group.objects.get_or_create(ref=key_group)
    if c:
        group.title = user.get_tipo_entidade_display()  
        group.active = True
        group.save()
    if group.users.filter(pk=user.pk).count() == 0:
        g = group.usergroup_group.create(user=user)
        g.save()

def save_presbitero(sender, **kwargs):
    presbitero = kwargs['instance']
    user, c = User.objects.get_or_create(import_model='Presbitero',import_pk=presbitero.pk)
    #user.arciprestado = presbitero.
    user.name = presbitero.nome
    user.email = presbitero.email
    if presbitero.telemovel is not None:
        user.number = presbitero.telemovel
    if presbitero.telemovel_privado is not None:
        user.number = (user.number + '/' if user.number is not None and user.number != '' else '') + presbitero.telemovel_privado
    
    if presbitero.tipo_clero:
        tipo_entidade = filter(lambda x: presbitero.tipo_clero == x[0], [
                                    (1,'8'),
                                    (2,'7'),
                                    (3,'2'),
                                    (4,'6'),
                                ])[0]
    else:
        tipo_entidade = None

    user.tipo_entidade = None if tipo_entidade is None else tipo_entidade[1]
    user.save()

    if presbitero.tipo_clero:
        insert_user_in_group(user)
    else:
        user.groups.all().delete()
    


post_save.connect(save_presbitero, sender=Presbitero)

def delete_presbitero(sender, **kwargs):
    presbitero = kwargs['instance']
    try:
        user = User.objects.get(import_model='Presbitero',import_pk=presbitero.pk)
        user.delete()
    except:
        pass

post_delete.connect(delete_presbitero, sender=Presbitero)



#------------------- region diacono
def save_diacono(sender, **kwargs):
    diacono = kwargs['instance']
    user, c = User.objects.get_or_create(import_model='Diacono',import_pk=diacono.pk)
    #user.arciprestado = presbitero.
    user.name = diacono.nome
    user.email = diacono.email
    if diacono.telemovel is not None:
        user.number = diacono.telemovel
    if diacono.telemovel_privado is not None:
        user.number = (user.number + '/' if user.number is not None and user.number != '' else '') + diacono.telemovel_privado
    user.tipo_entidade = '4'
    user.save()
    insert_user_in_group(user)

post_save.connect(save_diacono, sender=Diacono)

def delete_diacono(sender, **kwargs):
    diacono = kwargs['instance']
    try:
        user = User.objects.get(import_model='Diacono',import_pk=diacono.pk)
        user.delete()
    except:
        pass

post_delete.connect(delete_presbitero, sender=Diacono)

#------------------- endregion diacono



#------------------- region diaconopermanente
def save_diaconopermanente(sender, **kwargs):
    diacono = kwargs['instance']
    user, c = User.objects.get_or_create(import_model='DiaconoPermanente',import_pk=diacono.pk)
    #user.arciprestado = presbitero.
    user.name = diacono.nome
    user.email = diacono.email
    if diacono.telemovel is not None:
        user.number = diacono.telemovel
    if diacono.telemovel_privado is not None:
        user.number = (user.number + '/' if user.number is not None and user.number != '' else '') + diacono.telemovel_privado
    user.tipo_entidade = '3'
    user.save()
    insert_user_in_group(user)

post_save.connect(save_diaconopermanente, sender=DiaconoPermanente)

def delete_diaconopermanente(sender, **kwargs):
    diacono = kwargs['instance']
    try:
        user = User.objects.get(import_model='DiaconoPermanente',import_pk=diacono.pk)
        user.delete()
    except:
        pass

post_delete.connect(delete_diaconopermanente, sender=DiaconoPermanente)
#------------------- endregion diaconopermanente




#------------------- region bispo
def save_bispo(sender, **kwargs):
    diacono = kwargs['instance']
    user, c = User.objects.get_or_create(import_model='Bispo',import_pk=diacono.pk)
    #user.arciprestado = presbitero.
    user.name = diacono.nome
    user.email = diacono.email
    if diacono.telemovel is not None:
        user.number = diacono.telemovel
    if diacono.telemovel_privado is not None:
        user.number = (user.number + '/' if user.number is not None and user.number != '' else '') + diacono.telemovel_privado
    user.tipo_entidade = '1'
    user.save()
    insert_user_in_group(user)

post_save.connect(save_bispo, sender=Bispo)

def delete_bispo(sender, **kwargs):
    diacono = kwargs['instance']
    try:
        user = User.objects.get(import_model='Bispo',import_pk=diacono.pk)
        user.delete()
    except:
        pass

post_delete.connect(delete_bispo, sender=Bispo)
#------------------- endregion bispo