# -*- coding: utf-8 *-*


from myadmin.admin import MyBaseForm


from django.contrib import admin
from .models import WebSiteProfile, WebSiteUtilizador #, WebSite


from myadmin.admin import MyBaseAdmin



from .models import WebSite

from django.contrib.admin.widgets import FilteredSelectMultiple
from django.contrib import admin
from django import forms
from django.contrib.auth.models import User
from django.utils.translation import ugettext_lazy as _
from diocese.models import Arciprestado, Paroquia
from conteudos.models import Seccao



class WebSiteProfileInline(MyBaseForm, forms.ModelForm):
    arciprestado = forms.ModelChoiceField(label=_(u'Arciprestado'), queryset=Arciprestado.objects.all()) #, required=False
    sacerdotes_paroquia = forms.ModelChoiceField(label=_(u'Paróquia'), queryset=Paroquia.objects.all()) #, required=False



# Define an inline admin descriptor for UserProfile model
# which acts a bit like a singleton
class WebSiteProfileInline(admin.StackedInline):
    model = WebSiteProfile
    #form = WebSiteProfileInline
    can_delete = False
    verbose_name_plural = 'Configurações'
    raw_id_fields = ('avisos_seccao', 'conteudo_slide', 'contactos_noticia', 'horarios_horario', 'menu', 'home_noticia', 'home_noticias', 'fotogaleria_seccao',)#'sacerdotes_paroquia', 'horario_horario', 'videos_seccao', 
    #arciprestado = forms.ModelChoiceField(label=_(u'Arciprestado'), queryset=Arciprestado.objects.all()) #, required=False
    #sacerdotes_paroquia = forms.ModelChoiceField(label=_(u'Paróquia'), queryset=Paroquia.objects.all()) #, required=False




"""
# Define a new User admin
class UserAdmin(admin.ModelAdmin):
    inlines = (UserProfileInline, )

# Re-register UserAdmin
admin.site.unregister(WebSite)
admin.site.register(WebSite, UserAdmin)
"""


class WebSiteUtilizadorInline(admin.StackedInline):
    model = WebSiteUtilizador
    extra = 0

    #can_delete = False
    #verbose_name_plural = 'Configurações'
    raw_id_fields = ('website', 'utilizador',)
    unique_together = ('utilizador',)



class WebSiteAdminForm(MyBaseForm, forms.ModelForm):
    titulo = forms.CharField(label=u'Título')
    #url = forms.CharField(label=u'Url')
    #email = forms.EmailField(label=u'Email')
    #arciprestado = forms.ModelChoiceField(label=_(u'Arciprestado'), queryset=Arciprestado.objects.all()) #, required=False

    #seccao = forms.ModelChoiceField(label=_(u'Seccao'), queryset=Seccao.objects.all(), required=False)
    #seccao = forms.ModelChoiceField(label=_(u'Seccao'), queryset=Seccao.objects.all(), required=False)


    #users = forms.ModelMultipleChoiceField(User.objects.filter(is_active=True).all(),
    #label=_("users"),
    #widget= FilteredSelectMultiple(_("users"),
    #    False, attrs={'rows': '10'}), required=False)


    #class Meta:
    #    model = WebSite
    #B__d = forms.CharField(label=u'Título')


#class WebSiteAdmin(MyBaseAdmin, admin.ModelAdmin):
class WebSiteAdmin(admin.ModelAdmin):
    form = WebSiteAdminForm
    fieldsets = (
                 (None, {
                         'fields':(
                                   ('titulo'),
                                   #('url'),
                                   #('email'),
                                   #('arciprestado'),
                                   #('seccao'),
                                   #('users',),
                                   #('B__d',),
                                   )
                         }),
                 )
    list_display = ('titulo', 'activo')
    list_filter = ('activo', )
    search_fields = ('titulo', 'id', )
    inlines = (WebSiteUtilizadorInline, WebSiteProfileInline, )

admin.site.register(WebSite, WebSiteAdmin)




###




class WebSiteProfileForm(MyBaseForm, forms.ModelForm):
    url = forms.CharField(label=u'Url')
    email = forms.EmailField(label=u'Email')
    arciprestado = forms.ModelChoiceField(label=_(u'Arciprestado'), queryset=Arciprestado.objects.all()) #, required=False
    website = forms.ModelChoiceField(label=_(u'Website'), queryset=WebSite.objects.all(), required=False)
    sacerdotes_paroquia = forms.ModelChoiceField(label=_(u'Paróquia'), queryset=Paroquia.objects.all()) #, required=False


class WebSiteProfileAdmin(MyBaseAdmin, admin.ModelAdmin):
    form = WebSiteProfileForm
    raw_id_fields = ('avisos_seccao', 'conteudo_slide', 'contactos_noticia', 'horarios_horario', 'menu', 'home_noticia', 'home_noticias', 'fotogaleria_seccao',)#'sacerdotes_paroquia', 'horario_horario', 'videos_seccao', 
    exclude = ('website',)
admin.site.register(WebSiteProfile, WebSiteProfileAdmin)
