# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'WebSite'
        db.create_table('website_website', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('activo', self.gf('django.db.models.fields.BooleanField')(default=True)),
            ('url', self.gf('django.db.models.fields.URLField')(max_length=200)),
            ('titulo', self.gf('django.db.models.fields.CharField')(max_length=255)),
            ('email', self.gf('django.db.models.fields.EmailField')(max_length=75)),
            ('arciprestado', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websites_arciprestado', null=True, to=orm['diocese.Arciprestado'])),
        ))
        db.send_create_signal('website', ['WebSite'])

        # Adding M2M table for field users on 'WebSite'
        db.create_table('website_website_users', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('website', models.ForeignKey(orm['website.website'], null=False)),
            ('user', models.ForeignKey(orm['auth.user'], null=False))
        ))
        db.create_unique('website_website_users', ['website_id', 'user_id'])


    def backwards(self, orm):
        # Deleting model 'WebSite'
        db.delete_table('website_website')

        # Removing M2M table for field users on 'WebSite'
        db.delete_table('website_website_users')


    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'diocese.arciprestado': {
            'Meta': {'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.presbitero': {
            'Meta': {'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'website.website': {
            'Meta': {'object_name': 'WebSite'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_arciprestado'", 'null': 'True', 'to': "orm['diocese.Arciprestado']"}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'users': ('django.db.models.fields.related.ManyToManyField', [], {'blank': 'True', 'related_name': "'websites_websites_users'", 'null': 'True', 'symmetrical': 'False', 'to': "orm['auth.User']"})
        }
    }

    complete_apps = ['website']