# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'WebSiteProfile'
        db.create_table('website_websiteprofile', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('website', self.gf('django.db.models.fields.related.OneToOneField')(to=orm['website.WebSite'], unique=True)),
            ('facebook', self.gf('django.db.models.fields.URLField')(max_length=200, null=True, blank=True)),
            ('twitter', self.gf('django.db.models.fields.URLField')(max_length=200, null=True, blank=True)),
            ('youtube', self.gf('django.db.models.fields.URLField')(max_length=200, null=True, blank=True)),
            ('coordenadas_latitude', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('coordenadas_longitude', self.gf('django.db.models.fields.CharField')(max_length=255, null=True, blank=True)),
            ('conteudo_slide', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_conteudo_slide', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Fotogaleria'])),
            ('avisos_seccao', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_avisos_seccao', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Seccao'])),
            ('contactos_noticia', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_contactos_noticia', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Noticia'])),
            ('horarios_horario', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_horarios_horario', null=True, on_delete=models.SET_NULL, to=orm['horario.Horario'])),
            ('menu', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_menu', null=True, on_delete=models.SET_NULL, to=orm['sitemenu.Menu'])),
            ('home_noticia', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_conteudo_noticia', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Noticia'])),
            ('home_noticias', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_seccao_avisos', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Seccao'])),
            ('fotogaleria_seccao', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_fotogaleria_seccao', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Seccao'])),
            ('horario_horario', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_horario_horario', null=True, on_delete=models.SET_NULL, to=orm['horario.Horario'])),
            ('sacerdotes_paroquia', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_sacerdotes_paroquia', null=True, on_delete=models.SET_NULL, to=orm['diocese.Paroquia'])),
            ('videos_seccao', self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websiteprofiles_videos_seccao', null=True, on_delete=models.SET_NULL, to=orm['conteudos.Seccao'])),
        ))
        db.send_create_signal('website', ['WebSiteProfile'])

        # Adding field 'WebSite.paroquia'
        db.add_column('website_website', 'paroquia',
                      self.gf('django.db.models.fields.related.ForeignKey')(blank=True, related_name='websites_websites_paroquia', null=True, on_delete=models.SET_NULL, to=orm['diocese.Paroquia']),
                      keep_default=False)


        # Changing field 'WebSite.arciprestado'
        db.alter_column('website_website', 'arciprestado_id', self.gf('django.db.models.fields.related.ForeignKey')(null=True, on_delete=models.SET_NULL, to=orm['diocese.Arciprestado']))

    def backwards(self, orm):
        # Deleting model 'WebSiteProfile'
        db.delete_table('website_websiteprofile')

        # Deleting field 'WebSite.paroquia'
        db.delete_column('website_website', 'paroquia_id')


        # Changing field 'WebSite.arciprestado'
        db.alter_column('website_website', 'arciprestado_id', self.gf('django.db.models.fields.related.ForeignKey')(null=True, to=orm['diocese.Arciprestado']))

    models = {
        'auth.group': {
            'Meta': {'object_name': 'Group'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '80'}),
            'permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'})
        },
        'auth.permission': {
            'Meta': {'ordering': "('content_type__app_label', 'content_type__model', 'codename')", 'unique_together': "(('content_type', 'codename'),)", 'object_name': 'Permission'},
            'codename': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'content_type': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['contenttypes.ContentType']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '50'})
        },
        'auth.user': {
            'Meta': {'object_name': 'User'},
            'date_joined': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'groups': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Group']", 'symmetrical': 'False', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'is_active': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'is_staff': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'is_superuser': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'last_login': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '30', 'blank': 'True'}),
            'password': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'user_permissions': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['auth.Permission']", 'symmetrical': 'False', 'blank': 'True'}),
            'username': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '30'})
        },
        'contenttypes.contenttype': {
            'Meta': {'ordering': "('name',)", 'unique_together': "(('app_label', 'model'),)", 'object_name': 'ContentType', 'db_table': "'django_content_type'"},
            'app_label': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'model': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'})
        },
        'conteudos.fotogaleria': {
            'Meta': {'object_name': 'Fotogaleria'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleria_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_fotogaleria_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleria_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_fotogaleria_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_fotogaleria_fotogaleria_relacao'", 'to': "orm['conteudos.Fotogaleria']", 'through': "orm['conteudos.FotogaleriaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_fotogaleria_fotogaleria_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.FotogaleriaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudoss_fotogalerias_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.fotogaleriarelacao': {
            'Meta': {'unique_together': "(('fotogaleria', 'fotogaleria_rel'),)", 'object_name': 'FotogaleriaRelacao'},
            'fotogaleria': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriarelacao_noticia_ori'", 'to': "orm['conteudos.Fotogaleria']"}),
            'fotogaleria_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriarelacao_noticia_rel'", 'to': "orm['conteudos.Fotogaleria']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'conteudos.fotogaleriaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'FotogaleriaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriaseccao_multimedia'", 'to': "orm['conteudos.Fotogaleria']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_fotogaleriaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.noticia': {
            'Meta': {'object_name': 'Noticia'},
            'aceitar_comentarios': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_alterado_por'", 'to': "orm['auth.User']"}),
            'ante_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'autor': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'autor_capa_local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'capa': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticia_criado_por'", 'to': "orm['auth.User']"}),
            'equipa': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_equipa'", 'null': 'True', 'to': "orm['auth.User']"}),
            'foto1': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto2': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_noticia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'local': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'noticia': ('django.db.models.fields.TextField', [], {}),
            'pos_titulo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'relacoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_relacao'", 'to': "orm['conteudos.Noticia']", 'through': "orm['conteudos.NoticiaRelacao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'restrito': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'resumo': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'seccoes': ('django.db.models.fields.related.ManyToManyField', [], {'related_name': "'conteudos_noticia_noticia_seccao'", 'to': "orm['conteudos.Seccao']", 'through': "orm['conteudos.NoticiaSeccao']", 'blank': 'True', 'symmetrical': 'False', 'null': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudoss_noticias_website'", 'to': "orm['website.WebSite']"})
        },
        'conteudos.noticiarelacao': {
            'Meta': {'unique_together': "(('noticia', 'noticia_rel'),)", 'object_name': 'NoticiaRelacao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_ori'", 'to': "orm['conteudos.Noticia']"}),
            'noticia_rel': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiarelacao_noticia_rel'", 'to': "orm['conteudos.Noticia']"})
        },
        'conteudos.noticiaseccao': {
            'Meta': {'unique_together': "(('noticia', 'seccao'),)", 'object_name': 'NoticiaSeccao'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'noticia': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_noticia'", 'to': "orm['conteudos.Noticia']"}),
            'seccao': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_noticiaseccao_seccao'", 'to': "orm['conteudos.Seccao']"}),
            'seccao_publicacao': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'})
        },
        'conteudos.seccao': {
            'Meta': {'object_name': 'Seccao'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_alterado_por'", 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'conteudos_seccao_criado_por'", 'to': "orm['auth.User']"}),
            'descricao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'level': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'lft': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'parent': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'conteudos_seccao_parent'", 'null': 'True', 'to': "orm['conteudos.Seccao']"}),
            'rght': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'tree_id': ('django.db.models.fields.PositiveIntegerField', [], {'db_index': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'conteudoss_seccaos_website'", 'to': "orm['website.WebSite']"})
        },
        'diocese.arciprestado': {
            'Meta': {'ordering': "['arciprestado']", 'object_name': 'Arciprestado'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'arcipreste': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'arcipreste_adjunto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_arciprestado_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logo': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'presbitero_arcipreste': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste'", 'null': 'True', 'to': "orm['diocese.Presbitero']"}),
            'presbitero_arcipreste_adjunto': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_arciprestado_presbitero_arcipreste_adjunto'", 'null': 'True', 'to': "orm['diocese.Presbitero']"})
        },
        'diocese.paroquia': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Paroquia'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_alterado_por'", 'to': "orm['auth.User']"}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_paroquia_criado_por'", 'to': "orm['auth.User']"}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'horario_confissoes': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'horario_missas': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'orago': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '3', 'null': 'True', 'blank': 'True'}),
            'padre1': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre1'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'padre2': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre2'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'padre3': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_paroquia_paroquia_padre3'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Presbitero']"}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'})
        },
        'diocese.presbitero': {
            'Meta': {'ordering': "['nome']", 'object_name': 'Presbitero'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_alterado_por'", 'to': "orm['auth.User']"}),
            'arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'capelao': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'cartao_sacerdotal': ('django.db.models.fields.IntegerField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'clero_tipo': ('django.db.models.fields.PositiveIntegerField', [], {'default': '1', 'max_length': '1'}),
            'codigo_ecclesia': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'codigo_postal': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'diocese_presbitero_criado_por'", 'to': "orm['auth.User']"}),
            'data_faleceu': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_nascimento': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'data_ordenacoa': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'faleceu': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fax': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'formacao_permanente': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'foto': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'fraternidade_sacerdotal': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'diocese_presbitero_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'habilitacoes_academicas': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'igreja': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_nascimento': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'local_ordenacao': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'localidade': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'morada': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'nome': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'nomeacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'nomeacoes_actuais': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'obs': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'paginaweb': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'paroco': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'publicacoes': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'reitor': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'serv_pastoral': ('django.db.models.fields.TextField', [], {'null': 'True', 'blank': 'True'}),
            'telefone': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'telemovel_privado': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tipo_clero': ('django.db.models.fields.PositiveIntegerField', [], {'max_length': '1', 'null': 'True', 'blank': 'True'}),
            'vice_arcipreste': ('django.db.models.fields.BooleanField', [], {'default': 'False'})
        },
        'elfinder.filecollection': {
            'Meta': {'object_name': 'FileCollection'},
            'dir': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.CharField', [], {'max_length': '255'})
        },
        'horario.horario': {
            'Meta': {'object_name': 'Horario'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'alterado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'alterado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'horario_horario_alterado_por'", 'to': "orm['auth.User']"}),
            'aprovado': ('django.db.models.fields.DateTimeField', [], {'null': 'True', 'blank': 'True'}),
            'aprovado_por': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'horario_horario_aprovado_por'", 'null': 'True', 'to': "orm['auth.User']"}),
            'criado': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'blank': 'True'}),
            'criado_por': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'horario_horario_criado_por'", 'to': "orm['auth.User']"}),
            'fs': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'horario_horario_file_collection'", 'null': 'True', 'to': "orm['elfinder.FileCollection']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'publicada_fim': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True', 'null': 'True', 'blank': 'True'}),
            'publicada_inicio': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'null': 'True', 'db_index': 'True', 'blank': 'True'}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'horarios_horarios_website'", 'to': "orm['website.WebSite']"})
        },
        'sitemenu.menu': {
            'Meta': {'object_name': 'Menu'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'website': ('django.db.models.fields.related.ForeignKey', [], {'default': '1', 'related_name': "'sitemenus_menus_website'", 'to': "orm['website.WebSite']"})
        },
        'website.website': {
            'Meta': {'object_name': 'WebSite'},
            'activo': ('django.db.models.fields.BooleanField', [], {'default': 'True'}),
            'arciprestado': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_arciprestado'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Arciprestado']"}),
            'email': ('django.db.models.fields.EmailField', [], {'max_length': '75'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'paroquia': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websites_paroquia'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Paroquia']"}),
            'titulo': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'url': ('django.db.models.fields.URLField', [], {'max_length': '200'}),
            'users': ('django.db.models.fields.related.ManyToManyField', [], {'blank': 'True', 'related_name': "'websites_websites_users'", 'null': 'True', 'symmetrical': 'False', 'to': "orm['auth.User']"})
        },
        'website.websiteprofile': {
            'Meta': {'object_name': 'WebSiteProfile'},
            'avisos_seccao': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_avisos_seccao'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Seccao']"}),
            'contactos_noticia': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_contactos_noticia'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Noticia']"}),
            'conteudo_slide': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_conteudo_slide'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Fotogaleria']"}),
            'coordenadas_latitude': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'coordenadas_longitude': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'facebook': ('django.db.models.fields.URLField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'fotogaleria_seccao': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_fotogaleria_seccao'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Seccao']"}),
            'home_noticia': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_conteudo_noticia'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Noticia']"}),
            'home_noticias': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_seccao_avisos'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Seccao']"}),
            'horario_horario': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_horario_horario'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['horario.Horario']"}),
            'horarios_horario': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_horarios_horario'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['horario.Horario']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'menu': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_menu'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['sitemenu.Menu']"}),
            'sacerdotes_paroquia': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_sacerdotes_paroquia'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['diocese.Paroquia']"}),
            'twitter': ('django.db.models.fields.URLField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'}),
            'videos_seccao': ('django.db.models.fields.related.ForeignKey', [], {'blank': 'True', 'related_name': "'websites_websiteprofiles_videos_seccao'", 'null': 'True', 'on_delete': 'models.SET_NULL', 'to': "orm['conteudos.Seccao']"}),
            'website': ('django.db.models.fields.related.OneToOneField', [], {'to': "orm['website.WebSite']", 'unique': 'True'}),
            'youtube': ('django.db.models.fields.URLField', [], {'max_length': '200', 'null': 'True', 'blank': 'True'})
        }
    }

    complete_apps = ['website']