# -*- coding: utf-8 *-*
from django import forms
from django.db import models
from django.core.paginator import Paginator, InvalidPage
from django.http import Http404
from django.shortcuts import render_to_response

from haystack.views import SearchView
from haystack.forms import ModelSearchForm
#, model_choices

from diocese.models import Arciprestado

model_choices = [
	(None, 'Todas as Áreas'),
	#('conteudos.Noticia,diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo,diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,agenda.Agenda,diocese.CuriaDiocesana', 'Todas as Áreas'),
	('conteudos.Noticia', 'Noticias'),
	('diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo', 'Clero'),
	('diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular', 'Comunidades e Vida Religiosa'),
	('agenda.Agenda', 'Agenda'),
	('diocese.CuriaDiocesana', 'Cúria'),
]

class PesquisaForm(ModelSearchForm):
	search_letter = forms.CharField(required=False)

	def __init__(self, *args, **kwargs):
		super(PesquisaForm, self).__init__(*args, **kwargs)
		self.fields['models'] = forms.ChoiceField(choices=model_choices, initial=None, required=False, widget=forms.Select)

	def filtros_pesquisa(self):
		sqs = self.searchqueryset
		if len(self.cleaned_data['q'])>0:
			#sqs = sqs.autocomplete(titulo=self.cleaned_data['q'])
			#sqs = sqs.filter(text__icontains=self.cleaned_data['q'])
			sqs = sqs.autocomplete(text=self.cleaned_data['q'])
		if len(self.cleaned_data['search_letter'])>0:
			sqs = sqs.filter(letra__startswith=self.cleaned_data['search_letter'])

		sqs = sqs.filter(website=1)

		return sqs

	def search(self):
		if not self.is_valid():# or not self.cleaned_data.get('q'):
			return self.no_query_found()

		sqs = self.filtros_pesquisa()
		
		if self.load_all:
			sqs = sqs.load_all()
		#sqs = sqs
		return sqs.models(*self.get_models()).order_by('-date')

	def get_models(self):
		"""Return an alphabetical list of model classes in the index."""

		search_models = []

		if self.cleaned_data['models'] == 'None':
			#return []
			nonemodels = 'conteudos.Noticia,diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo,diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,agenda.Agenda,diocese.CuriaDiocesana'
			for model in nonemodels.split(','):
					search_models.append(models.get_model(*model.split('.')))
			return search_models

		if self.is_valid():
			if len(self.cleaned_data['models'].split(','))>1:
				for model in self.cleaned_data['models'].split(','):
					search_models.append(models.get_model(*model.split('.')))
			else:
				model = self.cleaned_data['models']
				search_models.append(models.get_model(*model.split('.')))
		
		return search_models


class Pesquisa(SearchView):
	def get_query(self):
		"""
		Returns the query provided by the user.

		Returns an empty string if the query is invalid.
		"""
		if self.form.is_valid():
			if len(self.form.cleaned_data['q'])>0:
				return self.form.cleaned_data['q']
			else:
				return self.form.cleaned_data['search_letter']
		return ''

	def build_page(self):
		try:
			page_no = int(self.request.GET.get('page', 1))
		except (TypeError, ValueError):
			raise Http404("Not a valid number for page.")

		if page_no < 1:
			raise Http404("Pages should be 1 or greater.")

		start_offset = (page_no - 1) * self.results_per_page

		self.results[start_offset:start_offset + self.results_per_page]
		
		paginator = Paginator(list(self.results), self.results_per_page)

		try:
			page = paginator.page(page_no)
		except InvalidPage:
			raise Http404("No such page!")

		return (paginator, page)

def PesquisaV():
	return Pesquisa(template = 'website/pesquisa.html', form_class=PesquisaForm)






model_choices_instituicoes = [
	(None, 'Tipo de Instituição'),
	
	#('diocese.AssociacaoObraPresbitero,diocese.AssociacaoMovimentoObra,diocese.CentroAnimacaoEspiritual,diocese.CentroVidaCrista,diocese.Chancelaria,diocese.ColegioArciprestes,diocese.ColegioConsultores,diocese.Comissao,diocese.ComunicacaoSocial,diocese.ConselhoPastoral,diocese.ConselhoPresbiteral,diocese.CuriaDiocesana,diocese.DiaconadoPermanente,diocese.EscolaCatolica,diocese.FormacaoAgentePastoral,diocese.GestaoRecursos,diocese.InstituicaoCultural,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,diocese.ObraAccaoSocioCaritativa,diocese.PrelaturaPessoal,diocese.Secretariado,diocese.Seminario,diocese.TribunalEclesiastico,diocese.OutraInstituicao','Tipo de Instituição'),

	('diocese.AssociacaoObraPresbitero', 'Associações e Obras para Presbíteros'),
	('diocese.AssociacaoMovimentoObra', 'Associações Movimentos e Obras'),
	('diocese.CentroAnimacaoEspiritual', 'Centros de Animação Espiritual'),	
	('diocese.CentroVidaCrista', 'Centros de Vida Cristã'),
	('diocese.Chancelaria', 'Chancelaria/secretaria geral'),
	('diocese.ColegioArciprestes', 'Colégio de Arciprestes'),
	('diocese.ColegioConsultores', 'Colégio de Consultores'),
	('diocese.Comissao', 'Comissões'),
	('diocese.ComunicacaoSocial', 'Comunicações Sociais'),
	('diocese.ConselhoPastoral', 'Conselho Pastoral'),
	('diocese.ConselhoPresbiteral', 'Conselho Presbiteral'),
	('diocese.CuriaDiocesana', 'Cúria Diocesana'),
	('diocese.DiaconadoPermanente', 'Diaconado Permanente'),
	('diocese.EscolaCatolica', 'Escolas Católicas'),
	('diocese.FormacaoAgentePastoral', 'Formação de Agentes de Pastoral'),
	('diocese.GestaoRecursos', 'Gestão de Recursos Pessoais, patrimoniais e financeiros'),
	('diocese.InstituicaoCultural', 'Instituições Culturais'),
	('diocese.InstitutoReligiosoFeminino', 'Institutos Religiosos Femininos'),
	('diocese.InstitutoReligiosoMasculino', 'Institutos Religiosos Masculinos'),
	('diocese.InstitutoSecular', 'Institutos Seculares'),
	('diocese.ObraAccaoSocioCaritativa', 'Obras de Acção Sócio Caritativa'),	
	('diocese.PrelaturaPessoal', 'Prelaturas Pessoais'),
	('diocese.Secretariado', 'Secretariados/serviços/departamentos'),
	('diocese.Seminario', 'Seminários'),
	('diocese.TribunalEclesiastico', 'Tribunais Eclesiástico'),
	('diocese.OutraInstituicao', 'Outras Instituições'),

]
"""
model_choices_instituicoes = [
	(None, 'Todas as Áreas'),
	#('conteudos.Noticia,diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo,diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,agenda.Agenda,diocese.CuriaDiocesana', 'Todas as Áreas'),
	('conteudos.Noticia', 'Noticias'),
	('diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo', 'Clero'),
	('diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular', 'Comunidades e Vida Religiosa'),
	('agenda.Agenda', 'Agenda'),
	('diocese.CuriaDiocesana', 'Cúria'),
]
"""

class InstituicoesForm(ModelSearchForm):
	search_letter = forms.CharField(required=False)

	def __init__(self, *args, **kwargs):
		super(InstituicoesForm, self).__init__(*args, **kwargs)
		self.fields['models'] = forms.ChoiceField(choices=model_choices_instituicoes, initial=None, required=False, widget=forms.Select)

	def filtros_instituicoes(self):
		sqs = self.searchqueryset
		if len(self.cleaned_data['q'])>0:
			#sqs = sqs.autocomplete(titulo=self.cleaned_data['q'])
			#sqs = sqs.filter(text__icontains=self.cleaned_data['q'])
			sqs = sqs.autocomplete(text=self.cleaned_data['q'])
		if len(self.cleaned_data['search_letter'])>0:
			sqs = sqs.filter(letra__startswith=self.cleaned_data['search_letter'])

		sqs = sqs.filter(website=1)

		return sqs

	def search(self):
		if not self.is_valid():# or not self.cleaned_data.get('q'):
			return self.no_query_found()

		sqs = self.filtros_instituicoes()
		
		if self.load_all:
			sqs = sqs.load_all()
		#sqs = sqs
		return sqs.models(*self.get_models()).order_by('-date')

	def get_models(self):
		"""Return an alphabetical list of model classes in the index."""

		search_models = []

		if self.cleaned_data['models'] == 'None':
			#return []
			nonemodels = 'diocese.AssociacaoObraPresbitero,diocese.AssociacaoMovimentoObra,diocese.CentroAnimacaoEspiritual,diocese.CentroVidaCrista,diocese.Chancelaria,diocese.ColegioArciprestes,diocese.ColegioConsultores,diocese.Comissao,diocese.ComunicacaoSocial,diocese.ConselhoPastoral,diocese.ConselhoPresbiteral,diocese.CuriaDiocesana,diocese.DiaconadoPermanente,diocese.EscolaCatolica,diocese.FormacaoAgentePastoral,diocese.GestaoRecursos,diocese.InstituicaoCultural,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,diocese.ObraAccaoSocioCaritativa,diocese.PrelaturaPessoal,diocese.Secretariado,diocese.Seminario,diocese.TribunalEclesiastico,diocese.OutraInstituicao'
			#nonemodels = 'conteudos.Noticia,diocese.Presbitero,diocese.DiaconoPermanente,diocese.Bispo,diocese.Seminario,diocese.InstitutoReligiosoFeminino,diocese.InstitutoReligiosoMasculino,diocese.InstitutoSecular,agenda.Agenda,diocese.CuriaDiocesana'
			for model in nonemodels.split(','):
					search_models.append(models.get_model(*model.split('.')))
			return search_models

		if self.is_valid():
			if len(self.cleaned_data['models'].split(','))>1:
				for model in self.cleaned_data['models'].split(','):
					search_models.append(models.get_model(*model.split('.')))
			else:
				model = self.cleaned_data['models']
				search_models.append(models.get_model(*model.split('.')))
		
		return search_models


class Instituicoes(SearchView):

	def get_query(self):
		"""
		Returns the query provided by the user.

		Returns an empty string if the query is invalid.
		"""
		if self.form.is_valid():
			if len(self.form.cleaned_data['q'])>0:
				return self.form.cleaned_data['q']
			else:
				return self.form.cleaned_data['search_letter']
		
		return ''

	def build_page(self):

		try:
			page_no = int(self.request.GET.get('page', 1))
		except (TypeError, ValueError):
			raise Http404("Not a valid number for page.")

		if page_no < 1:
			raise Http404("Pages should be 1 or greater.")

		start_offset = (page_no - 1) * self.results_per_page

		self.results[start_offset:start_offset + self.results_per_page]
		
		paginator = Paginator(list(self.results), self.results_per_page)

		try:
			page = paginator.page(page_no)
		except InvalidPage:
			raise Http404("No such page!")

		return (paginator, page)


	def extra_context(self):
		try:
			arciprestado_object = int(self.request.GET.get('arciprestado', None))
		except:
			arciprestado_object = None

		if arciprestado_object:
			arciprestado_object = Arciprestado.objects.get(pk=arciprestado_object)

		return {
			'arciprestado_object': arciprestado_object,
		}


def InstituicoesV():
	return Instituicoes(template = 'website/instituicoes.html', form_class=InstituicoesForm)